

;     IF_EQ
;     IF_ZERO
;     IF_NE
;     IF_NOT_ZERO
;     IF_PLUS
;     IF_MINUS
;     IF_C_SET
;     IF_C_CLR
;     IF_V_SET
;     IF_V_CLR
;     IF_FLAG_VAR       added Apr 2013
;     IF_BIT                  "
;     IF_MEM_BYTE_NEG         "
;     IF_MEM_BYTE_POS         "
;     IF_GE     ; These two should refer   * * * * *
;     IF_LT     ; to the C flag.
;     ELSE_
;     END_IF
;
;     BEGIN
;     WHILE_EQ
;     WHILE_NOT_EQ
;     WHILE_PL
;     WHILE_MI
;     WHILE_C_CLR
;     WHILE_C_SET
;     WHILE_V_CLR
;     WHILE_V_SET
;     WHILE_BIT         added Apr 2013
;     REPEAT
;     AGAIN
;     UNTIL_EQ
;     UNTIL_NE
;     UNTIL_PL
;     UNTIL_MI
;     UNTIL_C_CLR
;     UNTIL_C_SET
;     UNTIL_V_CLR
;     UNTIL_V_SET
;     UNTIL_BIT         added Apr 2013
;
;     CASE
;     CASE_OF
;     END_OF
;     END_CASE

;     FOR
;     NEXT
;     FOR_X             added Apr 2013
;     NEX_X                    "
;     FOR_Y                    "
;     NEXT_Y                   "

;     RTS_IF_EQ                "
;     RTS_IF_NEQ               "
;     RTS_IF_PLUS              "
;     RTS_IF_MINUS             "
;     RTS_IF_FLAG_VAR          "
;     RTS_IF_BIT               "




   LIST "OFF"
STK_LVL_1:     SETL  0          ; Define these before they are used in macros.
STK_LVL_2:     SETL  0
STK_LVL_3:     SETL  0
STK_LVL_4:     SETL  0
STK_LVL_5:     SETL  0
STK_LVL_6:     SETL  0
STK_LVL_7:     SETL  0
STK_LVL_8:     SETL  0
STK_LVL_9:     SETL  0
STK_LVL_10:    SETL  0
STK_LVL_11:    SETL  0
STK_LVL_12:    SETL  0
STK_LVL_13:    SETL  0
STK_LVL_14:    SETL  0
STK_LVL_15:    SETL  0
STK_LVL_16:    SETL  0
STK_LVL_17:    SETL  0
STK_LVL_18:    SETL  0
STK_LVL_19:    SETL  0
STK_LVL_20:    SETL  0
STK_SWAP_TEMP: SETL  0
CUR_ADR:       SETL  0
   LIST "ON"


IS_SET:   EQU  1
IS_CLEAR: EQU  0

IS_HIGH:  EQU  1
IS_LOW:   EQU  0

IS_NEG:   EQU  2
IS_POS:   EQU  1
IS_0:     EQU  0
IS_NON_0: EQU  3




;                         +--------------------------+
;                         |  IF_xx...ELSE_...END_IF  |
;                         +==========================+

IF_EQ:      MACRO
            BNE   $                ; Lay down the BNE op code plus a placekeeper for the operand,
            INCL  "STAKPUSH.ASM"   ; and push a cell on the stack.
 TO_PUSH_1: SETL  $                ; Put the addr of that operand in that top-of-stack cell.
            ENDM                   ; BNE's operand will be filled in by either ELSE_ or END_IF.
 ;----------------

ELSE_:      MACRO                  ; Don't forget the "_" in "ELSE_" ! ! !  (to differentiate from the assembler's conditional)
            BRA  $                 ; Lay down the BRA op code plus a placekeeper for the operand.
 CUR_ADR:   SETL $                 ; Keep the current address to restore below.
            ORG  STK_LVL_1 - 1     ; Go back to the place for the IF's Bxx's operand, to fill it in now.
            DFB  CUR_ADR-STK_LVL_1 ; DFB in C32 is "DeFine Byte," .DB or BYTE in others.
            ORG  CUR_ADR           ; Now after completing IF's Bxx's operand, come back to resume assembling new code.
 STK_LVL_1: SETL $                 ; We can re-use the same stack cell now, since we have already filled in the first
            ENDM                   ; branch operand.  This new SETL will be for END_IF to fill in ELSE_'s BRA operand.
 ;----------------                 ; Note that ELSE_ assembles only a single instruction, a forward branch.

END_IF:     MACRO                  ; The similar directive in the C32 assembler is ENDI, so there's no mix-up here.
 CUR_ADR:   SETL $                 ; Save the current address, because we have to temporarily change it for filling in
            ORG  STK_LVL_1 - 1     ; the branch operand for the preceding IF or ELSE_.
            DFB  CUR_ADR-STK_LVL_1
            INCL "STACKPOP.ASM"    ; We're done with this stack level now, so we can drop it.
            ORG  CUR_ADR           ; With earlier branch-forward instructions' operands filled in, we come back to
            ENDM                   ; resume assembling new code where we left off.  Note that END_IF adds not a single
 ;----------------                 ; byte to the code, only fills in operands in the IF or optional ELSE_ above.

IF_ZERO:    MACRO                  ; Same thing as IF_EQ above.
            BNE   $
            INCL  "STAKPUSH.ASM"
 TO_PUSH_1: SETL  $
            ENDM
 ;----------------
IF_NEQ:     MACRO
            BEQ   $
            INCL  "STAKPUSH.ASM"
 TO_PUSH_1: SETL  $
            ENDM
 ;----------------
IF_NOT_ZERO: MACRO                 ; Same thing as IF_NEQ above.
             BEQ   $
             INCL  "STAKPUSH.ASM"
 TO_PUSH_1:  SETL  $
             ENDM
 ;----------------
IF_PLUS:    MACRO                  ; Uses N flag.
            BMI   $
            INCL  "STAKPUSH.ASM"
 TO_PUSH_1: SETL  $
            ENDM
 ;----------------
IF_MINUS:   MACRO                  ; Uses N flag.
            BPL   $
            INCL  "STAKPUSH.ASM"
 TO_PUSH_1: SETL  $
            ENDM
 ;----------------
IF_NEG:     MACRO                  ; Uses N flag.
            BPL   $
            INCL  "STAKPUSH.ASM"
 TO_PUSH_1: SETL  $
            ENDM
 ;----------------
IF_C_SET:   MACRO
            BCC   $
            INCL  "STAKPUSH.ASM"
 TO_PUSH_1: SETL  $
            ENDM
 ;----------------
IF_C_CLR:   MACRO
            BCS   $
            INCL  "STAKPUSH.ASM"
 TO_PUSH_1: SETL  $
            ENDM
 ;----------------
IF_GE:      MACRO                  ; Same as IF_C_SET above.
            BCC   $
            INCL  "STAKPUSH.ASM"
 TO_PUSH_1: SETL  $
            ENDM
 ;----------------
IF_LT:      MACRO                  ; Same as IF_C_CLEAR above.
            BCS   $
            INCL  "STAKPUSH.ASM"
 TO_PUSH_1: SETL  $
            ENDM
 ;----------------
IF_V_SET:   MACRO
            BVC   $
            INCL  "STAKPUSH.ASM"
 TO_PUSH_1: SETL  $
            ENDM
 ;----------------
IF_V_CLR:   MACRO
            BVS   $
            INCL  "STAKPUSH.ASM"
 TO_PUSH_1: SETL  $
            ENDM
 ;----------------

IF_FLAG_VAR:    MACRO  FLAG, CONDX      ; For flag variables.  (Only tests bit 7.)       Syn:   IF_FLAG_VAR  PTT_FLAG, IS_SET
                BIT  FLAG               ; If you have the BBS & BBR instructions, then instead of always using BIT and BPL/BMI,
                IF CONDX == IS_SET      ; you could also have the macro watch for the flag being in ZP and have it use BBR/BBS in
                   BPL  $               ; that case, to save an instruction.  I virtually never have flag variables in ZP though.
                ELSE
                   BMI  $
                ENDI
                INCL    "STAKPUSH.ASM"
 TO_PUSH_1:     SETL    $
                ENDM
 ;------------------

IF_BIT:   MACRO  MEM_ADR, BIT_NR, CONDX               ; (Tests a bit in a memory location.)    Syn:   IF_BIT  VIA3PB, 4, IS_LOW
                                                      ; Accum gets changed if you specify a bit other than 6 or 7.
          IF  ! {{ BIT_NR == 6 } || { BIT_NR == 7 }}  ; This 1st part only does bits 0-5, since we can branch on N or Z for 6 & 7.
              LDA  # { 1 << BIT_NR }
              BIT  MEM_ADR
              IF   CONDX == IS_HIGH                   ; The 2nd function of BIT is to AND the accum with the mem and set Z if the
                   BEQ  $                             ; result is 0, otherwise clear it.  Specifying IS_SET means you do the
              ELSE                                    ; following code if the bit is set.  A set bit results in Z flag clear.
                   BNE  $
              ENDI
          ELSE
              BIT  MEM_ADR
              IF   BIT_NR == 7                        ; For bit 7, branch on N.
                   IF   CONDX == IS_HIGH
                        BPL  $
                   ELSE
                        BMI  $
                   ENDI
              ELSE                                    ; By process of elimination, the only bit left here is 6, so branch on V.
                   IF   CONDX == IS_HIGH
                        BVC  $
                   ELSE
                        BVS  $
                   ENDI
              ENDI                      ; If you have the BBS & BBR instructions, then instead of always using BIT and Bxx,
          ENDI                          ; you could also have the macro watch for the adr being in ZP and have it use BBR/BBS in
          INCL     "STAKPUSH.ASM"       ; that case, for efficiency.  That's mostly for if you have I/O in ZP though, which is
 TO_PUSH_1: SETL     $                  ; very rare outside of microcontrollers like the Rockwell 65c19.
          ENDM
 ;------------------

IF_MEM_BYTE_NEG: MACRO  ADR             ; "If the memory byte is negative..."
                 BIT    ADR             ; As above, if you have the BBS & BBR instructions...well, you know what to do.
                 BPL    $
                 INCL   "STAKPUSH.ASM"
 TO_PUSH_1:      SETL   $
                 ENDM
 ;------------------

IF_MEM_BYTE_POS: MACRO  ADR             ; "If memory byte is positive," or more accurately, "If memory byte is not negative"
                 BIT    ADR             ; As above, if you have the BBS & BBR instructions...well, you know what to do.
                 BMI    $
                 INCL   "STAKPUSH.ASM"
 TO_PUSH_1:      SETL   $
                 ENDM
 ;------------------







;                        +--------------------------+
;                        |      BEGIN...AGAIN       |
;                        |      BEGIN...UNTIL       |
;                        |  BEGIN...WHILE...REPEAT  |
;                        +==========================+

BEGIN:      MACRO                   ; For use with AGAIN, REPEAT, and any of the UNTIL_xx and WHILE_xx macros.
            INCL  "STAKPUSH.ASM"    ; Push all previous stack vales down the stack to free up the top stack cell, then
 TO_PUSH_1: SETL  $                 ; put the address of the top of the loop into that cell so UNTIL or THEN or REPEAT
            ENDM                    ; will know where to branch up to.  BEGIN does not actually add any machine code.
 ;----------------
UNTIL_EQ:   MACRO                   ; Continue loop until Z flag is set.
            BNE  STK_LVL_1          ; Branch up to the top of the loop to the addr kept in the top structure-macro stack level.
            INCL "STACKPOP.ASM"     ; We're done with that stack cell, so drop it.
            ENDM
 ;----------------
AGAIN:      MACRO                   ; Continue loop unconditionally.  Similar to REPEAT, but not for use with WHILE_xx.
            BRA  STK_LVL_1          ; (same kind of thing as UNTIL_EQ above)
            INCL "STACKPOP.ASM"
            ENDM
 ;----------------
WHILE_NEQ:  MACRO                   ; Continue while Z flag is clear.  For use with BEGIN and REPEAT.
            BEQ   $                 ; Lay down the BEQ op code plus a placekeeper for the operand,
            INCL  "STAKPUSH.ASM"    ; and push another cell on the stack.  (BEGIN's cell is still there, underneath.)
 TO_PUSH_1: SETL  $                 ; Put the addr of that operand in that top-of-stack cell
            ENDM                    ; for REPEAT to come fill in the BEQ operand later.
 ;----------------
REPEAT:     MACRO                   ; Similar to AGAIN, but for use with WHILE_xx.
            BRA   STK_LVL_2         ; Assemble a branch back to the top of the loop.
 CUR_ADR:   SETL  $                 ; Save the current address to come back to,
            ORG   STK_LVL_1 - 1     ; go to the address of the WHILE branch operand,
            DFB   CUR_ADR-STK_LVL_1 ; and fill it in.
            ORG   CUR_ADR           ; Restore the program pointer to continue assembly after the structure.
            INCL  "STAKPOP2.ASM"    ; We're done with two stack cells now, so drop them.  Note that REPEAT
            ENDM                    ; actually only adds two bytes to the code, ie, those of the BRA instruction.
 ;----------------


WHILE_EQ:    MACRO                  ; For use with BEGIN and REPEAT.
             BNE   $                ; (same kind of thing as WHILE_NE above)
             INCL  "STAKPUSH.ASM"
 TO_PUSH_1:  SETL  $
             ENDM
 ;----------------
WHILE_ZERO:  MACRO                  ; Same as WHILE_EQ above.
             BNE   $
             INCL  "STAKPUSH.ASM"
 TO_PUSH_1:  SETL  $
             ENDM
 ;----------------
WHILE_NOT_ZERO: MACRO               ; Same as WHILE_NEQ above.
             BEQ   $
             INCL  "STAKPUSH.ASM"
 TO_PUSH_1:  SETL  $
             ENDM
 ;----------------
WHILE_MINUS: MACRO
             BPL   $
             INCL  "STAKPUSH.ASM"
 TO_PUSH_1:  SETL  $
             ENDM
 ;----------------
WHILE_NEG:   MACRO                 ; Same as WHILE_MI above.
             BPL   $
             INCL  "STAKPUSH.ASM"
 TO_PUSH_1:  SETL  $
             ENDM
 ;----------------
WHILE_PLUS:  MACRO
             BMI   $
             INCL  "STAKPUSH.ASM"
 TO_PUSH_1:  SETL  $
             ENDM
 ;----------------
WHILE_C_SET: MACRO                 ; Continue down in loop if carry flag is set.  Same as WHILE_GE below.
             BCC   $
             INCL  "STAKPUSH.ASM"
 TO_PUSH_1:  SETL  $
             ENDM
 ;----------------
WHILE_GE:    MACRO                 ; Continue down in loop if result greater than or equal, like WHILE_CS above.
             BCC   $
             INCL  "STAKPUSH.ASM"
 TO_PUSH_1:  SETL  $
             ENDM
 ;----------------
WHILE_C_CLR: MACRO                 ; Continue down in loop if carry flag is clear.  Same as WHILE_LT below.
             BCS   $
             INCL  "STAKPUSH.ASM"
 TO_PUSH_1:  SETL  $
             ENDM
 ;----------------
WHILE_LT:    MACRO                 ; Continue down in loop if result less than, like WHILE_CC above.
             BCS   $
             INCL  "STAKPUSH.ASM"
 TO_PUSH_1:  SETL  $
             ENDM
 ;----------------
WHILE_V_SET: MACRO
             BVC   $
             INCL  "STAKPUSH.ASM"
 TO_PUSH_1:  SETL  $
             ENDM
 ;----------------
WHILE_V_CLR: MACRO
             BVS   $
             INCL  "STAKPUSH.ASM"
 TO_PUSH_1:  SETL  $
             ENDM
 ;----------------

WHILE_BIT:  MACRO  ADR, BIT_NR, CONDX                 ; Syn:    WHILE_BIT  VIA3PA, 4, IS_LOW     (added 4/5/13)  Tests a bit in a
                                                      ; memory location.  Accum is changed if you specify a bit other than 6 or 7.

          IF  ! {{ BIT_NR == 6 } || { BIT_NR == 7 }}  ; This 1st part only does bits 0-5, since we can branch on N or Z for 6 & 7.
              LDA  # { 1 << BIT_NR }
              BIT  ADR
              IF   CONDX == IS_HIGH                   ; The 2nd function of BIT is to AND the accum with the mem and set Z if the
                   BEQ  $                             ; result is 0, otherwise clear it.  Specifying IS_SET means you do the
              ELSE                                    ; following code if the bit is set.  A set bit results in Z flag clear.
                   BNE  $
              ENDI
          ELSE
              BIT  ADR
              IF   BIT_NR == 7                        ; For bit 7, branch on N.
                   IF   CONDX == IS_HIGH
                        BPL  $
                   ELSE
                        BMI  $
                   ENDI
              ELSE                                    ; By process of elimination, the only bit left here is 6, so branch on V.
                   IF   CONDX == IS_HIGH
                        BVC  $
                   ELSE
                        BVS  $
                   ENDI
              ENDI                      ; If you have the BBS & BBR instructions, then instead of always using BIT and Bxx,
          ENDI                          ; you could also have the macro watch for the adr being in ZP and have it use BBR/BBS in
          INCL     "STAKPUSH.ASM"       ; that case, for efficiency.  That's mostly for if you have I/O in ZP though, which is
 TO_PUSH_1: SETL     $                  ; very rare outside of microcontrollers like the Rockwell 65c19.
          ENDM
 ;--------------------------

                                   ; The UNTIL macros are for use with BEGIN but not WHILE.
UNTIL_ZERO:  MACRO                 ; Continue loop until Z flag is set, same as UNTIL_EQ above.
             BNE  STK_LVL_1
             INCL "STACKPOP.ASM"
             ENDM
 ;----------------
UNTIL_NEQ:   MACRO                 ; Continue loop until the Z flag is clear.  Could also be called simply UNTIL .
             BEQ  STK_LVL_1        ; (This line is the same kind of thing as in UNTIL_EQ above)
             INCL "STACKPOP.ASM"
             ENDM
 ;----------------
UNTIL_NOT_ZERO:  MACRO             ; Same as UNTIL_NEQ above.
             BEQ  STK_LVL_1
             INCL "STACKPOP.ASM"
             ENDM
 ;----------------
UNTIL_MINUS: MACRO                 ; Continue loop until the N flag is set.  Could also be called UNTIL_NEG .
             BPL  STK_LVL_1
             INCL "STACKPOP.ASM"
             ENDM
 ;----------------
UNTIL_NEG:   MACRO                 ; Same as UNTIL_MI.
             BPL  STK_LVL_1
             INCL "STACKPOP.ASM"
             ENDM
 ;----------------
UNTIL_PLUS:  MACRO                 ; Continue loop until the N flag is clear.
             BMI  STK_LVL_1
             INCL "STACKPOP.ASM"
             ENDM
 ;----------------
UNTIL_C_SET: MACRO                 ; Continue loop until the C flag is set.  Same as UNTIL_GE below.
             BCC  STK_LVL_1
             INCL "STACKPOP.ASM"
             ENDM
 ;----------------
UNTIL_GE:    MACRO                 ; Continue loop until the C flag is set (for greater than or equal).
             BCC  STK_LVL_1
             INCL "STACKPOP.ASM"
             ENDM
 ;----------------
UNTIL_C_CLR: MACRO                 ; Continue loop until the C flag is clear.  Same as UNTIL_LT below.
             BCS  STK_LVL_1
             INCL "STACKPOP.ASM"
             ENDM
 ;----------------
UNTIL_LT:    MACRO                 ; Continue loop until the C flag is clear (for less than).
             BCS  STK_LVL_1
             INCL "STACKPOP.ASM"
             ENDM
 ;----------------
UNTIL_V_SET: MACRO
             BVC  STK_LVL_1
             INCL "STACKPOP.ASM"
             ENDM
 ;----------------
UNTIL_V_CLR: MACRO
             BVS  STK_LVL_1
             INCL "STACKPOP.ASM"
             ENDM
 ;----------------

UNTIL_BIT:  MACRO  ADR, BIT_NR, CONDX                 ; Syn:    UNTIL_BIT  VIA3PA, 4, IS_LOW      (added 4/5/13)  Tests a bit in a
                                                      ; memory location.  Accum is changed if you specify a bit other than 6 or 7.

          IF  ! {{ BIT_NR == 6 } || { BIT_NR == 7 }}  ; This 1st part only does bits 0-5, since we can branch on N or Z for 6 & 7.
              LDA  # { 1 << BIT_NR }
              BIT  ADR
              IF   CONDX == IS_HIGH                   ; The 2nd function of BIT is to AND the accum with the mem and set Z if the
                   BEQ  STK_LVL_1                     ; result is 0, otherwise clear it.  Specifying IS_SET means you do the
              ELSE                                    ; following code if the bit is set.  A set bit results in Z flag clear.
                   BNE  STK_LVL_1
              ENDI
          ELSE
              BIT  ADR
              IF   BIT_NR == 7                        ; For bit 7, branch on N.
                   IF   CONDX == IS_HIGH
                        BPL  STK_LVL_1
                   ELSE
                        BMI  STK_LVL_1
                   ENDI
              ELSE                                    ; By process of elimination, the only bit left here is 6, so branch on V.
                   IF   CONDX == IS_HIGH
                        BVC  STK_LVL_1
                   ELSE
                        BVS  STK_LVL_1
                   ENDI
              ENDI                      ; If you have the BBS & BBR instructions, then instead of always using BIT and Bxx,
          ENDI                          ; you could also have the macro watch for the adr being in ZP and have it use BBR/BBS in
          INCL     "STACKPOP.ASM"       ; that case, for efficiency.  That's mostly for if you have I/O in ZP though, which is
          ENDM                          ; very rare outside of microcontrollers like the Rockwell 65c19.
 ;--------------------------




;                        +--------------------+
;                        |   CASE statement   |
;                        +====================+

 ; Number of cases is a minimum of two and a maximum of 16.
 ; For this version using JMPs at the END_OFs, the only places that branch distances might be excessive is the BNEs in CASE_OF,
 ; and it's pretty unlikey that those would be a problem.
 ; Nested CASE statements are not permitted; ie, between CASE and END_CASE, you can't have another CASE...
 ; You can however nest a CASE structure with other types of structures.

Nr_of_cases:  SETL    0   ; This gets incremented by each CASE_OF, so the END_CASE knows how many branch operands to fill in.
Case_reg:     SETL    0   ; ACCUM, X_REG, or Y_REG.  This gets recorded by CASE, getting the macro parameter value.
ACCUM:        EQU  $101   ; A constant for Case_reg above.    ; These are over $100 so they can be used in FOR_X & FOR_Y also, and
X_REG:        EQU  $102   ;              "                    ; give the option to use existing register values or transfer them
Y_REG:        EQU  $103   ;              "                    ; from other registers without confusing them with 8-bit literals.
OF_addr:      SETL    0   ; Each END_OF uses this to fill in the branch addr of the preceding CASE_OF's BNE.


CASE:   MACRO  reg        ; reg will be either ACCUM, X_REG, or Y_REG, so the CASE_OF's will know whether to use CMP, CPX, or CPY.
 CASE1brAdr:    SETL  0   ; Init each of these assembler variables.  END_CASE then knows to only go back and fill in the
 CASE2brAdr:    SETL  0   ; branch operands of END_OF's that were actually used, because the unused ones will leave these
 CASE3brAdr:    SETL  0   ; assembler variables here at 0.
 CASE4brAdr:    SETL  0
 CASE5brAdr:    SETL  0
 CASE6brAdr:    SETL  0
 CASE7brAdr:    SETL  0
 CASE8brAdr:    SETL  0
 CASE9brAdr:    SETL  0
 CASE10brAdr:   SETL  0
 CASE11brAdr:   SETL  0
 CASE12brAdr:   SETL  0
 CASE13brAdr:   SETL  0
 CASE14brAdr:   SETL  0
 CASE15brAdr:   SETL  0
 CASE16brAdr:   SETL  0
 Case_rag:      SETL  reg ; Another C32 bug: It replaced "reg" in "Case_reg" with ACCUM, etc., so I had to misspell it "rag".
 Nr_of_cases:   SETL  0   ; Gets incremented with each CASE_OF, so the END_OF's know which assembler variable to put their branch
        ENDM              ; operands' address in.       Note that the CASE macro does not add even a single byte of machine code.
;-----------------

CASE_OF:  MACRO  Nr_to_comp_to          ; Note that as written here, the same register (A, X, or Y) must have
 Nr_of_cases:   SETL  Nr_of_cases + 1   ; the right number every time CASE_OF is encountered.  This is normally
        IF Case_rag == ACCUM            ; not a problem if no action is taken until a case match if found;
           CMP  #Nr_to_comp_to          ; but if you have any reason to put code between an END_OF and the
        ENDI                            ; following CASE_OF, make sure the right number is in the chosen
        IF Case_rag == X_REG            ; register (A, X, or Y) when the next CASE_OF is encountered.
           CPX  #Nr_to_comp_to
        ENDI
        IF Case_rag == Y_REG            ; Again the explanation of another C32 bug: I had to misspell "reg" here "rag" because
           CPY  #Nr_to_comp_to          ; the CASE macro was trying to substitute part of the label itself as mentioned above.
        ENDI
        BNE     $                       ; The BNE is used to branch only to the end of the individual case.
 OF_addr:       SETL  $                 ; The END_OF uses this to fill in the branch address.
        ENDM
 ;----------------

END_OF: MACRO
        JMP     $                       ; First assemble the jump to the END_CASE for if the condition was met.
                                        ; (I originally used BRA but it was too limiting for large CASE structures.  Although
        IF Nr_of_cases == 1             ; JMP takes an extra byte, it does not take any more time, and may even save a cycle.)
           CASE1brAdr: SETL $
        ENDI
        IF Nr_of_cases == 2
           CASE2brAdr: SETL $
        ENDI
        IF Nr_of_cases == 3
           CASE3brAdr: SETL $
        ENDI
        IF Nr_of_cases == 4
           CASE4brAdr: SETL $
        ENDI
        IF Nr_of_cases == 5
           CASE5brAdr: SETL $
        ENDI
        IF Nr_of_cases == 6
           CASE6brAdr: SETL $
        ENDI
        IF Nr_of_cases == 7
           CASE7brAdr: SETL $
        ENDI
        IF Nr_of_cases == 8
           CASE8brAdr: SETL $
        ENDI
        IF Nr_of_cases == 9
           CASE9brAdr: SETL $
        ENDI
        IF Nr_of_cases == 10
           CASE10brAdr: SETL $
        ENDI
        IF Nr_of_cases == 11
           CASE11brAdr: SETL $
        ENDI
        IF Nr_of_cases == 12
           CASE12brAdr: SETL $
        ENDI
        IF Nr_of_cases == 13
           CASE13brAdr: SETL $
        ENDI
        IF Nr_of_cases == 14
           CASE14brAdr: SETL $
        ENDI
        IF Nr_of_cases == 15
           CASE15brAdr: SETL $
        ENDI
        IF Nr_of_cases == 16
           CASE16brAdr: SETL $
        ENDI                            ; Note!  This is not the end of the macro yet!

 CUR_ADR:       SETL    $               ; Then fill in the branch address for the preceeding CASE_OF.
        ORG     OF_addr-1
        DFB     CUR_ADR-OF_addr         ; (CASE_OFs use relative branching to the END_OF, whereas END_OF will use JMP.
        ORG     CUR_ADR
        ENDM
 ;----------------

END_OF_:  MACRO                         ; This one (with the trailing "_") omits the JMP, for when it is either immediately
                                        ; preceded by an unconditional RTS, JMP, or branch, or where the next line is END_CASE.
 CUR_ADR:       SETL    $               ; Fill in the branch address for the preceeding CASE_OF.  The corresponding CASExbrAdr
        ORG     OF_addr-1               ; will remain at 0 (from CASE init'ing it), so END_CASE will not try to fill in a jump
        DFB     CUR_ADR-OF_addr         ; address.
        ORG     CUR_ADR
        ENDM
 ;----------------

END_CASE:  MACRO                        ; END_CASE does not compile anything new; it only
 CUR_ADR:       SETL    $               ; completes the branch addresses at the preceeding END_OFs (but leaves END_OF_s alone).
        ORG     CASE1brAdr-2
        DWL     CUR_ADR                 ; It is expected that a CASE statement will have at least two cases,
        ORG     CASE2brAdr-2            ; so we don't test to see if the first two exist.  We just do them.
        DWL     CUR_ADR

        IF CASE3brAdr != 0
           ORG  CASE3brAdr-2
           DWL  CUR_ADR
        ENDI
        IF CASE4brAdr != 0
           ORG  CASE4brAdr-2
           DWL  CUR_ADR
        ENDI
        IF CASE5brAdr != 0
           ORG  CASE5brAdr-2
           DWL  CUR_ADR
        ENDI
        IF CASE6brAdr != 0
           ORG  CASE6brAdr-2
           DWL  CUR_ADR
        ENDI
        IF CASE7brAdr != 0
           ORG  CASE7brAdr-2
           DWL  CUR_ADR
        ENDI
        IF CASE8brAdr != 0
           ORG  CASE8brAdr-2
           DWL  CUR_ADR
        ENDI
        IF CASE9brAdr != 0
           ORG  CASE9brAdr-2
           DWL  CUR_ADR
        ENDI
        IF CASE10brAdr != 0
           ORG  CASE10brAdr-2
           DWL  CUR_ADR
        ENDI
        IF CASE11brAdr != 0
           ORG  CASE11brAdr-2
           DWL  CUR_ADR
        ENDI
        IF CASE12brAdr != 0
           ORG  CASE12brAdr-2
           DWL  CUR_ADR
        ENDI
        IF CASE13brAdr != 0
           ORG  CASE13brAdr-2
           DWL  CUR_ADR
        ENDI
        IF CASE14brAdr != 0
           ORG  CASE14brAdr-2
           DWL  CUR_ADR
        ENDI
        IF CASE15brAdr != 0
           ORG  CASE15brAdr-2
           DWL  CUR_ADR
        ENDI
        IF CASE16brAdr != 0
           ORG  CASE16brAdr-2
           DWL  CUR_ADR
        ENDI
        ORG     CUR_ADR
        ENDM
 ;----------------------------





;                       +--------------------+
;                       |     FOR...NEXT     |
;                       +====================+


 ; As stated in the macros.html page, there are many different combinations to implement in a FOR...NEXT,
 ; and it's perhaps not possible to do them all in the same macros.  FOR...NEXT below is a suggestion of
 ; one way to do a loop needing more than 255 iterations.  This first FOR...NEXT pair is for when the
 ; index begins and ends with constants, and it increments by 1 unless you put something between the FOR
 ; and NEXT to modify the index variable.  FOR_X...NEXT_X and FOR_Y...NEXT_Y further down replace many of
 ; the more-common loops where X or Y is used as the counter, being 8-bit for 6502.


; For FOR...NEXT (where the counter is 16-bit):
; var1:   DFS   2  ; 2-byte index variable.  Call it whatever you want and put in your source code.
TO:       EQU   0  ; This is a dummy constant to make the FOR macro call more English-like.
FOR_LIM:  SETL  0  ; Assembler variable to transfer the limit from the FOR macro to the NEXT macro.
FOR_ADR:  SETL  0  ; This holds the address of the top of the loop so NEXT knows where to branch.

 ; example usage:
 ;
 ;      FOR  var1, 1, TO, 1000    ; (Unfotunately C32 macros require commas between the parameters.)
 ;         <actions>              ; For this, the loop does run 1000 times, dropping out when NEXT
 ;         <actions>              ; increments the counter to 1001.  No so for FOR_X etc. further down.
 ;      NEXT  var1


 ; Darn!  I find bugs in _every_ commercial software package I use!  So here's another one in C32
 ; (in addition to the one of macros substituting parameters even in labels and comment words,
 ; and possibly the problem of the INCL directive not being carried out until after the ENDM )!
 ; Using the high and low bytes of 16-bit values for 8-bit operands is supposed to use > and <
 ; respectively, but in macros, it thinks they're supposed to be binary operators.  My jury-rig
 ; fix is to do the "& $FF" for the low byte and ">> 8 } & $FF" for the high byte.


FOR:      MACRO  var_name, index, dummy, limit
          LDA   #{ index & $FF }          ; Store the starting counter value
          STA   var_name                  ; in the specified 2-byte variable.
          LDA   #{{ index >> 8 } & $FF }
          STA   var_name+1
 FOR_LIM: SETL  limit                     ; (This is used by NEXT.)
 FOR_ADR: SETL  $                         ; (Addr of top of loop for NEXT to branch back up to.)
          ENDM
 ;----------------
NEXT:     MACRO var_name
          INC   var_name
          BNE   nx1
          INC   var_name+1

 nx1:     LDA  var_name
          CMP  #{{ FOR_LIM + 1 } & $FF }  ; If the incremented variable is not 1 past the limit,
          BNE  FOR_ADR                    ; then branch to the top of the loop again.
          LDA  var_name+1
          CMP  #{{{ FOR_LIM + 1 } >> 8 } & $FF }
          BNE  FOR_ADR                                        ; Watch the branch distance.
                                     ; If, after being incremented, the specified variable
          ENDM                       ; matches the limit +1 (checking both bytes), drop through.
 ;----------------------------




;                        +--------------------+
;                        |   FOR_X...NEXT_X   |
;                        +====================+

 ; FOR_X...NEXT_X and FOR_Y...NEXT_Y below cover most of the senarios you could want for looping with X or Y as the counter, just
 ; as efficiently as you would do without the macros.
 ;
 ; Initial index values for either X or Y can be:
 ;      pre-existing accumulator contents (specifying "ACCUM")
 ;      pre-existing X-register contents  (specifying "X_REG")
 ;      pre-existing Y-register contents  (specifying "Y_REG")
 ;      a specified constant between 0 and $FF inclusive.
 ;
 ; You can:
 ;      count down one at a time (by specifying "DOWN_TO")
 ;      count  up  one at a time (by specifying "UP_TO"  )
 ; If you want two at a time, you would have to precede the NEXT_X or NEXT_Y with an extra INX/INY/DEX/DEY.  For other numbers,
 ; you can of course alter X or Y in the loop.
 ;
 ; The limit can be:
 ;      a specified constant between 0 and $FF inclusive
 ;      the contents of a non-ZP variable above $102 (since $101 and $102 are the numerical representation for NEG_NRs and POS_NRs)
 ;      or you can specify that it loop until the index becomes negative or positive (watching bit 7) by specifying:
 ;              UP_TO,   NEG_NRs
 ;              DOWN_TO, NEG_NRs
 ;              UP_TO,   POS_NRs
 ;              DOWN_TO, POS_NRs
 ;
 ; FOR_X...NEXT_X and FOR_Y...NEXT_Y below are nestable.  Their limitations are:
 ;    1. The counter must be 8-bit index reg X or Y, not a variable.  They can count up or down though, from/to any 8-bit value.
 ;    2. The initial index can be a constant, or it can be what's already in A, X, or Y.  The macro won't fetch it from a variable.
 ;        If it's a constant, it can of course be calculated by the assembler.
 ;    3. The limit can be any 8-bit constant, or it can be in a non-ZP variable above address $102.  The loop can alter the
 ;        variable.  If you use a constant, it can of course be computed by the assembler.
 ;    4. NEXT_X and NEXT_Y do the comparison of the index to the limit _after_ the increment or decrement, and drop through if
 ;        there's a match; so the loop will not be run with the final "to" value.  IOW,  "FOR  COUNT, 8, DOWN_TO, 0" will run 8
 ;        times, not 9:   8, 7, 6, 5, 4, 3, 2, and 1, but not 0.  If you want 9, do "9, DOWN_TO, 0" or "8, DOWN_TO, NEG_NRs".
 ;    5. The loop must be short enough that a relative branch at the end will reach the top.  It is rare that loops are too long.
 ;
 ; The NEXT_X and NEXT_Y macros are 44 lines long and yet might assemble only two instructions, like DEX, BNE.
 ;
 ; LEAVE_LOOP could be implemented, but the complexity is probably not justified considering the rare need.  I'm leaving it out for
 ; now, and if there's a need, it can be handled in more-conventional ways, like a branch instruction to a label after the loop.
 ; Otherwise, what you could do is use an additional stack level, and have FOR_X or FOR_Y initialize it as 0.  Then if there's a
 ; LEAVE_LOOP, it would store the address of its branch instruction in that stack cell, and NEXT_X or NEXT_Y would test it to see
 ; if that cell is non-0 and fill it in with a branch to the end if so.  You would have to be careful not to put the LEAVE_LOOP
 ; inside another structure that might be using the macro structure stack.  Also, allowing more than one LEAVE_LOOP would
 ; complicate things furter.  And as always, "compiler" security is up the to programmer.

 ; The number of clock cycles taken for a loop which loads its own index (call it "N") into X or Y and decrements it to 0 is:
 ;
 ;    2                    for loading X or Y immediate  (Omit this if you're starting with what was already there.)
 ;  + N * loop_contents    your code in the loop, plus the 2 clocks for DEX or DEY, meaning an empty loop still has N * 2.
 ;  + (N-1) * 3            for BNE top_of_loop.  The 3 turns to 4 if the loop straddles a page boundary.  (Usually it doesn't.)
 ;  + 2                    for final BNE that does not branch.
 ;
 ; So for:
 ;     FOR_X  8, DOWN_TO, 0
 ;     NEXT_X
 ; you have 2 + 16 + 21 + 2 = 41 clocks.  (The PIC16 takes 100 to do the same thing.)
 ;
 ;
 ; More syntax examples:
 ;
 ; FOR_X   ACCUM, DOWN_TO, 0            ; FOR_X will assemble TAX, and the loop will be done as many times as the accumulator's
 ; NEXT_X                               ; initial contents say.  The NEXT_X will assemble DEX, BNE.
 ;
 ; FOR_X   X_REG, DOWN_TO, NEG_NRs      ; Will start with whatever is already in X, and decrement until it sees you're below 0.
 ; NEXT_X                               ; The NEXT_X will assemble DEX, BPL.  If you add an DEX in the loop, the end result could
 ;                                      ; be either $FF or $FE, and this works without CPX.
 ;
 ; FOR_X   0, UP_TO, $40                ; Will do 40 iterations from 0 to $3F.  For will assemble LDX #0.
 ; NEXT_X                               ; NEXT_X will assemble INX, CPX #$40, BNE.
 ;
 ; FOR_X   Y_REG, UP_TO, FOOBAR         ; FOR_X will assemble PHY, PLX, leaving A undisturbed.  Loop until X matches contents of
 ; NEXT_X                               ; non-ZP variable FOOBAR.  NEXT_X will assemble INX, CMP FOOBAR, BNE.  Note that the
 ;                                      ; contents of the loop could even modify the contents of the variable between comparisons.
 ;
 ; FOR_X   $F0, DOWN_TO, POS_NRs        ; FOR_X will assemble LDX #F0.  Loop until X's high bit is clear.
 ; NEXT_X                               ; NEXT_X will assemble DEX, BMI.
 ;
 ; FOR_Y   15, DOWN_TO, $FF             ; FOR_Y will assemble LDY #15.
 ; NEXT_Y                               ; NEXT_Y will assemble DEY, BPL.  (If you put "DOWN_TO, $FE" though, it will add the CPX #.




DOWN_TO:  EQU  0
UP_TO:    EQU  1

NEG_NRs:  EQU  $101       ; negative numbers, like to drop through when an INX/DEX/INY/DEY turns the index value negative
POS_NRs:  EQU  $102       ; positive numbers, like to drop through when an INX/DEX/INY/DEY turns the index value non-negative
                          ; (These are above $FF so they won't be confused with 8-bit literals.)


; These were defined up in the CASE section:
; ACCUM:      EQU  $101   ; A constant for Case_reg above.    ; These are over $100 so they can be used in FOR_X & FOR_Y also, and
; X_REG:      EQU  $102   ;              "                    ; give the option to use existing register values or transfer them
; Y_REG:      EQU  $103   ;              "                    ; from other registers without confusing them with 8-bit literals.



FOR_X:      MACRO  index, dir, limit   ; Syn:  FOR_X  8,  DOWN_TO,  0       ; Example runs 8 times: 8, 7, 6, 5, 4, 3, 2, and 1,
            IF index == ACCUM          ;                                    ; but drops thru when the DEX at the end takes X to 0.
               TAX                     ; Syn:  FOR_X  ACCUM,  UP_TO,  $7F   ; This syntax example will lay down a TAX to start.
            ELSE
               IF index == Y_REG
                  PHY                  ; NOTE:  TYA TAX would be faster but would alter the accumulator.
                  PLX                  ;        It is not expected that this "Y_REG" option would be used often though.
               ELSE
                  IF index != X_REG    ; This one is for literals as in the first syntax example above (8 down to 0).
                     LDX   #index
                  ENDI                 ; The only possibility left is that you want to start with the value already in X, so we
               ENDI                    ; don't need an ELSE to tell it to do nothing.
            ENDI
            INCL  "STKPUSH3.ASM"
 TO_PUSH_1: SETL  $                    ; STK_LVL_1 will hold the addr of the top of the loop for NEXT to branch up to.
 TO_PUSH_2: SETL  dir                  ; STK_LVL_2 will record whether NEXT_X should INX (action = 1) or DEX (action = 0).
 TO_PUSH_3: SETL  limit                ; Record what ending number NEXT should be watching for.  When the INX or DEX takes X to
            ENDM                       ; that final target, the branch to the top of the loop will not be taken which is why the
 ;----------------                     ; example above of 8 down to 0 runs the loop only 8 times, not 9.
                                       ; Note that there's nothing keeping you from modifying X during loop execution if you wish.

NEXT_X:     MACRO
            IF  STK_LVL_2 == DOWN_TO                                                     ; If it's supposed to count down,
                DEX                                                                      ; assemble DEX before anything else.
                IF  STK_LVL_3 == 0                                                       ; Down to 0 is pretty normal,
                    BNE  STK_LVL_1                                                       ; using BNE.
                ELSE
                    IF {STK_LVL_3 == $FF} || {STK_LVL_3 == -1} || {STK_LVL_3 == NEG_NRs} ; Going 'til index is negative is pretty
                        BPL  STK_LVL_1                                                   ; normal too, using BPL.
                    ELSE
                        IF  STK_LVL_3 == POS_NRs                                         ; Likewise going 'til the index turns
                            BMI  STK_LVL_1                                               ; positive, using BMI.
                        ELSE                                                             ; Now if the limit is > 8-bit, and above
                            IF  STK_LVL_3 > $102                                         ; the POS_NRs specifier, do a CMP abs
                                CPX  STK_LVL_3                                           ; to the specified non-ZP RAM variable.
                            ELSE                                                         ; The only possibility left now is that
                                CPX  #STK_LVL_3                                          ; you want to compare to an 8-bit
                            ENDI                                                         ; constant, so use CPX #.
                            BNE  STK_LVL_1                                               ; Either of these will be followed by BNE.
                        ENDI
                    ENDI
                ENDI
            ELSE                                                                         ; If it was supposed to count up,
                INX                                                                      ; assemble INX before anything else.
                IF  STK_LVL_3 == 0                                                       ; Up to 0 is pretty normal,
                    BNE  STK_LVL_1                                                       ; using BNE.
                ELSE
                    IF  STK_LVL_3 == POS_NRs                                             ; If you want to count up from negative
                        BMI  STK_LVL_1                                                   ; to positive numbers, use BMI.
                    ELSE
                        IF  STK_LVL_3 == NEG_NRs                                         ; To count up from positive to negative
                            BPL  STK_LVL_1                                               ; numbers, use BPL.
                        ELSE                                                             ; Now if the limit is > 8-bit, and above
                            IF  STK_LVL_3 > $102                                         ; the POS_NRs specifier, do a CMP abs
                                CPX  STK_LVL_3                                           ; to the specified non_ZP RAM variable.
                            ELSE                                                         ; The only possibility left now is that
                                CPX  #STK_LVL_3                                          ; you want to compare to an 8-bit
                            ENDI                                                         ; constant, so use CPX #.
                            BNE  STK_LVL_1                                               ; Either of these will be followed by BNE.
                        ENDI
                    ENDI
                ENDI
            ENDI
            INCL   "STAKPOP3.ASM"
            ENDM
 ;------------------

FOR_Y:      MACRO  index, dir, limit   ; Syn:  FOR_Y  8,  DOWN_TO,  0       ; Example runs 8 times: 8, 7, 6, 5, 4, 3, 2, and 1,
            IF index == ACCUM          ;                                    ; but drops thru when the DEY at the end takes Y to 0.
               TAY                     ; Syn:  FOR_Y  ACCUM,  UP_TO,  $7A   ; This syntax example will lay down a TAY to start.
            ELSE
               IF index == X_REG
                  PHX                  ; NOTE:  TXA TAY would be faster but would alter the accumulator.
                  PLY                  ;        It is not expected that this "X_REG" option would be used often though.
               ELSE
                  IF index != Y_REG    ; This one is for literals as in the first syntax example above (8 down to 0).
                     LDY   #index
                  ENDI                 ; The only possibility left is that you want to start with the value already in Y, so we
               ENDI                    ; don't need an ELSE to tell it to do nothing.
            ENDI
            INCL  "STKPUSH3.ASM"
 TO_PUSH_1: SETL  $                    ; STK_LVL_1 will hold the addr of the top of the loop for NEXT to branch up to.
 TO_PUSH_2: SETL  dir                  ; STK_LVL_2 will record whether NEXT_Y should INY (action = 1) or DEY (action = 0).
 TO_PUSH_3: SETL  limit                ; Record what ending number NEXT should be watching for.  When the INY or DEY takes Y to
            ENDM                       ; that final target, the branch to the top of the loop will not be taken which is why the
 ;----------------                     ; example above of 8 down to 0 runs the loop only 8 times, not 9.
                                       ; Note that there's nothing keeping you from modifying Y during loop execution if you wish.

NEXT_Y:     MACRO
            IF  STK_LVL_2 == DOWN_TO                                                     ; If it's supposed to count down,
                DEY                                                                      ; assemble DEY before anything else.
                IF  STK_LVL_3 == 0                                                       ; Down to 0 is pretty normal,
                    BNE  STK_LVL_1                                                       ; using BNE.
                ELSE
                    IF {STK_LVL_3 == $FF} || {STK_LVL_3 == -1} || {STK_LVL_3 == NEG_NRs} ; Going 'til index is negative is pretty
                        BPL  STK_LVL_1                                                   ; normal too, using BPL.
                    ELSE
                        IF  STK_LVL_3 == POS_NRs                                         ; Likewise going 'til the index turns
                            BMI  STK_LVL_1                                               ; positive, using BMI.
                        ELSE                                                             ; Now if the limit is > 8-bit, and above
                            IF  STK_LVL_3 > $102                                         ; the POS_NRs specifier, do a CMP abs
                                CPY  STK_LVL_3                                           ; to the specified non-ZP RAM variable.
                            ELSE                                                         ; The only possibility left now is that
                                CPY  #STK_LVL_3                                          ; you want to compare to an 8-bit
                            ENDI                                                         ; constant, so use CPY #.
                            BNE  STK_LVL_1                                               ; Either of these will be followed by BNE.
                        ENDI
                    ENDI
                ENDI
            ELSE                                                                         ; If it was supposed to count up,
                INY                                                                      ; assemble INY before anything else.
                IF  STK_LVL_3 == 0                                                       ; Up to 0 is pretty normal,
                    BNE  STK_LVL_1                                                       ; using BNE.
                ELSE
                    IF  STK_LVL_3 == POS_NRs                                             ; If you want to count up from negative
                        BMI  STK_LVL_1                                                   ; to positive numbers, use BMI.
                    ELSE
                        IF  STK_LVL_3 == NEG_NRs                                         ; To count up from positive to negative
                            BPL  STK_LVL_1                                               ; numbers, use BPL.
                        ELSE                                                             ; Now if the limit is > 8-bit, and above
                            IF  STK_LVL_3 > $102                                         ; the POS_NRs specifier, do a CMP abs
                                CPY  STK_LVL_3                                           ; to the specified non_ZP RAM variable.
                            ELSE                                                         ; The only possibility left now is that
                                CPY  #STK_LVL_3                                          ; you want to compare to an 8-bit
                            ENDI                                                         ; constant, so use CPY #.
                            BNE  STK_LVL_1                                               ; Either of these will be followed by BNE.
                        ENDI
                    ENDI
                ENDI
            ENDI
            INCL   "STAKPOP3.ASM"
            ENDM
 ;------------------




 ;                       +--------------------+
 ;                       |     Accessories    |
 ;                       +====================+

 ; It is common to want to exit a routine under certain conditions, without necessarily even finishing executing a program
 ; structure.  Here are some macros I have found helpful.  These do not need the assembler stack, so they do not affect
 ; nesting at all.


RTS_IF_EQ:   MACRO                      ; Takes 1 more byte than conditionally branching to the nearest RTS already there.
        BNE  rie                        ; Timing is about the same, whether 3 & 8 clocks for the macro or 2 & 8 without the macro.
        RTS
 rie:
        ENDM
 ;------------------

RTS_IF_NE:   MACRO
        BEQ  rine
        RTS
 rine:
        ENDM
 ;------------------

RTS_IF_PLUS:  MACRO
        BMI  rip
        RTS
 rip:
        ENDM
 ;------------------

RTS_IF_MINUS:  MACRO
        BPL   rim
        RTS
 rim:
        ENDM
 ;------------------

RTS_IF_FLAG_VAR:        MACRO  FLAG, CONDX      ; (only tests bit 7)       Syn:  RTS_IF_FLAG_VAR  PTT_FLAG, IS_SET
        BIT  FLAG
        IF CONDX == IS_SET
           BPL  rfv
        ELSE
           BMI  rfv
        ENDIF
        RTS
 rfv:
        ENDM
 ;------------------

RTS_IF_BIT:  MACRO  MEM_ADR, BIT_NR, CONDX            ; RTS based on the value of the specified bit in specified memory location.
                                                      ; Syn:   RTS_IF_BIT  VIA3PB, 4, IS_LOW
                                                      ; Accum gets changed if you specify a bit other than 6 or 7.
          IF  ! {{ BIT_NR == 6 } || { BIT_NR == 7 }}  ; This 1st part only does bits 0-5, since we can branch on N or Z for 6 & 7.
              LDA  # { 1 << BIT_NR }
              BIT  MEM_ADR
              IF   CONDX == IS_HIGH                   ; The 2nd function of BIT is to AND the accum with the mem and set Z if the
                   BEQ  rib                           ; result is 0, otherwise clear it.  Specifying IS_SET means you do the
              ELSE                                    ; following code if the bit is set.  A set bit results in Z flag clear.
                   BNE  rib
              ENDI
          ELSE
              BIT  MEM_ADR
              IF   BIT_NR == 7                        ; For bit 7, branch on N.
                   IF   CONDX == IS_HIGH
                        BPL  rib
                   ELSE
                        BMI  rib
                   ENDI
              ELSE                                    ; By process of elimination, the only bit left here is 6, so branch on V.
                   IF   CONDX == IS_HIGH
                        BVC  rib
                   ELSE
                        BVS  rib                                ; RTS_IF_BIT IS VERY CONFUSING, SO TEST THOROUGHLY!  * * * * *
                   ENDI
              ENDI                      ; If you have the BBS & BBR instructions, then instead of always using BIT and Bxx,
          ENDI                          ; you could also have the macro watch for the adr being in ZP and have it use BBR/BBS in
          RTS                           ; that case, for efficiency.  That's mostly for if you have I/O in ZP though, which is
 rib:                                   ; very rare outside of microcontrollers like the Rockwell 65c19.
          ENDM
 ;------------------

RTS_IF_MEM_LOC:  MACRO  ADR, CONDX      ; RTS if memory location is positive/negative/zero/non-0.  Alters Y for IS_0 or IS_NON_0.
                                        ; Syn:    RTS_IF_MEM_LOC  TIME  IS_NEG
        IF CONDX == IS_POS
           BIT  ADR
           BMI  riml
        ENDI

        IF CONDX == IS_NEG
           BIT  ADR
           BPL  riml
        ENDI

        IF CONDX == IS_0
           LDY  ADR                     ; It is less likely that altering Y at the exit of a subroutine will upset anything
           BNE  riml                    ; than altering A or X will, so I did Y.  You can change it if you need to of course.
        ENDI

        IF CONDX == IS_NON_0
           LDY  ADR
           BEQ  riml
        ENDI

        RTS
 riml:
        ENDM
 ;------------------


 ; and of course you can add more as the need arises, or change the names if you don't like mine.
